//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: When the counter value is the same as TA0DRA, the TCA0 interrupt occurs.
//****************************************** 
//******************************************
//Stack Pointer	=	0x23f (If use mq6822_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 

void main()
{
  	
 	P7CR.bit.b2	= 0;		//set P72 input
	
	__asm("DI");
	POFFCR0.byte = 0x1;
	EIRH.bit.b6 = 1;
	__asm("EI");
	TA0CR.byte = 0xC2; //enable overflow interrupt,TFF=1,no noise canceller,
	TA0MOD.byte = 0x82; //double buffer,event count mode
	TA0DRAL.byte = 0x5;
	TA0DRAH.byte = 0x0;  //counting register = 0x0005
	TA0CR.bit.b0 = 1;	//start Timer Counter
	while(1)
	{
		WDCDR.byte= 0x4e;	//clear WDT
	} 
	
}